﻿$(document).ready(function () {
    initializeCardSorts();
});

function selectCard(bucket, item) {
    item.appendTo(bucket);
    organizeCards();
    item.find(".cardValue").val(bucket.attr("data-value")).trigger("change");
}

function unselectCard(item) {
    var cardGroup = $(".cardList").find(".cardGroup[data-group='" + item.attr("data-group") + "']");

    if (cardGroup != null) {
        item.appendTo(cardGroup);
        item.find(".cardValue").val("").trigger("change");
        organizeCards();
    }
}

function initializeCardSorts() {
    initializeCards();
    organizeCards();
    $(".card").on("client-skip-show", organizeCards);
    $(".cardSort .bucketList .bucket.softPromptChoice").hide();
}

function initializeCards() {
    $(".cardSortContent").each(function () {
        $(this).disableSelection();

        var scope = $(this);
        var scopeId = scope.attr("id");
        var textHeight = 0;

        $(".cardList", scope).droppable({
            accept: ".card",
            scope: scopeId
        });

        $(".cardList", scope).on("drop", function (event, ui) {
            unselectCard(ui.draggable);
        });

        $(".bucket", scope).each(function () {
            $(this).droppable({
                accept: ".card",
                scope: scopeId
            });

            $(this).on("drop", function (event, ui) {
                selectCard($(this), ui.draggable);
            });

            var bucketTextHeight = $(this).find(".headerText").height();

            if (bucketTextHeight > textHeight) {
                textHeight = bucketTextHeight;
            }
        });

        $(".card", scope).each(function () {
            $(this).draggable({
                revert: "invalid",
                helper: "original",
                cursor: "move",
                scope: scopeId,
                refreshPositions: true,
                stack: ".card",
                containment: $(this).closest(".cardSortContent")
            });

            if ($(this).attr("data-group") == null) {
                $(this).attr("data-group", scopeId + "_default");
            }

            var textDiv = $(this).find(".textDiv");

            if (textDiv != null) {
                var top = ($(this).height() / 2) - (textDiv.height() / 2);

                if (top > 0) {
                    textDiv.css("top", top + "px");
                }
            }
        });

        $(".cardGroup", scope).each(function () {
            var cardGroup = $(this);
            var cardGroupName = cardGroup.attr("data-group");
            var cardsInGroup = scope.find(".card[data-group='" + cardGroupName + "']");

            if (cardsInGroup && cardsInGroup.length > 0) {
                scope.find(".card[data-group='" + cardGroupName + "']").each(function () {
                    var cardValue = $(this).find('.cardValue').val();

                    if (cardValue != null && cardValue != "") {
                        var bucket = scope.find(".bucket[data-value='" + cardValue + "']");

                        if (bucket != null) {
                            $(this).appendTo(bucket);
                        }
                    } else {
                        $(this).appendTo(cardGroup);
                    }
                });

                var groupTextHeight = $(this).find(".headerText").height();

                if (groupTextHeight > textHeight) {
                    textHeight = groupTextHeight;
                }
            } else {
                cardGroup.hide();
            }
        });

        if (textHeight > 0)
            $(".bucket .headerText, .cardGroup .headerText", scope).height(textHeight);

        if ($(this).hasClass("vertical")) {
            $(this).find(".cardList").height($(this).find(".bucketList").height());
        }

        $(".cardGroup, .bucket", scope).each(function () {
            var panel = $(this).parents(".cardSortContent");
            var stack = panel.attr("data-stackcards") === undefined || panel.attr("data-stackcards") == "true";
            var stackPadding = stack ? 2 : 0;
            var cardsCount = $(this).children(".card").length;
            var firstCard = $(".card", panel).first();
            var cardsWidth = firstCard.outerWidth() + (stackPadding * cardsCount);
            var cardsHeight = firstCard.outerHeight() + (stackPadding * cardsCount);
            var hasHeight = $(this).attr("data-hasheight");

            if (!$(this).attr("data-haswidth")) {
                $(this).width(cardsWidth);
            }

            if (!hasHeight) {
                $(this).height(cardsHeight + textHeight + 8);
            }
        });
    });
}

function organizeCards() {
    $(".cardGroup, .bucket").each(function () {
        var panel = $(this).parents(".cardSortContent");
        var stack = panel.attr("data-stackcards") === undefined || panel.attr("data-stackcards") == "true";
        var stackPadding = stack ? 2 : 0;
        var cardsCount = $(this).children(".card").length;
        var firstCard = $(".card", panel).first();
        var textHeight = $(this).find(".headerText").outerHeight();
        var cardsWidth = firstCard.outerWidth() + (stackPadding * cardsCount);
        var cardsHeight = firstCard.outerHeight() + (stackPadding * cardsCount);
        var position = $(this).offset();
        var hasHeight = $(this).attr("data-hasheight");

        if ($(this).is(".bucket")) {
            if (!$(this).attr("data-haswidth")) {
                $(this).width(cardsWidth);
            }

            position.left += ($(this).outerWidth() / 2) - (cardsWidth / 2);

            if (!hasHeight) {
                $(this).height(cardsHeight + textHeight + 8);
            }

            var bucketHeight = $(this).outerHeight();

            if (!hasHeight) {
                bucketHeight += textHeight;
            }

            position.top += (bucketHeight / 2) - (cardsHeight / 2);
        } else {
            position.top += textHeight;
        }

        $(this).children(".card").each(function () {
            $(this).offset(position);
            position.left += stackPadding;
            position.top += stackPadding;
        });
    });
}